//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// GenPoly.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Nov 24 15:24:38 2015
// Update Count     : 6
//

#ifndef GENPOLY_H
#define GENPOLY_H

#include <map>
#include <string>
#include <iostream>

#include "SynTree/Declaration.h"
#include "SynTree/TypeSubstitution.h"

namespace GenPoly {
	typedef std::map< std::string, TypeDecl::Kind > TyVarMap;

	/// A function needs an adapter if it returns a polymorphic value or if any of its
	/// parameters have polymorphic type
	bool needsAdapter( FunctionType *adaptee, const TyVarMap &tyVarr );

	/// true iff function has polymorphic return type
	bool isPolyRet( FunctionType *function, std::string &name, const TyVarMap &otherTyVars );
	bool isPolyRet( FunctionType *function, std::string &name );
	bool isPolyRet( FunctionType *function, const TyVarMap &otherTyVars );

	/// returns polymorphic type if is polymorphic type, NULL otherwise; will look up substitution in env if provided
	Type *isPolyType( Type *type, const TyVarMap &tyVars, const TypeSubstitution *env = 0 );

	/// returns polymorphic type if is pointer to polymorphic type, NULL otherwise; will look up substitution in env if provided
	Type *isPolyPtr( Type *type, const TyVarMap &tyVars, const TypeSubstitution *env = 0 );

	/// Prints type variable map
	void printTyVarMap( std::ostream &os, const TyVarMap &tyVarMap );

	/// Gets the name of the sizeof parameter for the type
	std::string sizeofName( Type *ty );

	/// Gets the name of the alignof parameter for the type
	std::string alignofName( Type *ty );
} // namespace GenPoly

#endif // GENPOLY_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
