#include <stdlib>
#include <stdlib.h>
#include "pair"
#include "bench.h"
#include "cfa-stack.h"

int main(int argc, char** argv) {
	srand(20171025);

	stack(int) s;
	REPEAT_TIMED( "push_int",
		push( &s, rand() );
	)

	stack(int) t;
	TIMED( "copy_int", 
		t = s;
	)

	TIMED( "clear_int", 
		clear( &s );
	)

	int max = 0;
	REPEAT_TIMED( "pop_int", 
		max = max( max, pop( &t ) );
	)

	stack(pair(_Bool, char)) s2;
	REPEAT_TIMED( "push_bool_char",
		push( &s2, (pair(_Bool, char)){ rand() & 0x1, rand() & 0x7F } );
	)

	stack(pair(_Bool, char)) t2;
	TIMED( "copy_bool_char", 
		t2 = s2;
	)

	TIMED( "clear_bool_char", 
		clear( &s2 );
	)

	pair(_Bool, char) max2 = { (_Bool)0, '\0' };
	REPEAT_TIMED( "pop_bool_char",
		max2 = max( max2, pop( &t2 ) );
	)
}