#pragma once

#include <stdlib.h>
#include <malloc.h>

// supported mallopt options
#ifndef M_MMAP_THRESHOLD
#define M_MMAP_THRESHOLD (-1)
#endif // M_MMAP_THRESHOLD

#ifndef M_TOP_PAD
#define M_TOP_PAD (-2)
#endif // M_TOP_PAD

extern "C" {
	void * malloc( size_t size );
	void * aalloc( size_t dim, size_t elemSize );
	void * calloc( size_t dim, size_t elemSize );
	void * resize( void * oaddr, size_t size );
	void * realloc( void * oaddr, size_t size );
	void * memalign( size_t alignment, size_t size );
	void * amemalign( size_t align, size_t dim, size_t elemSize );
	void * cmemalign( size_t align, size_t dim, size_t elemSize );
	void * valloc( size_t size );
	void * pvalloc( size_t size );
	void free( void * addr );
	size_t malloc_alignment( void * addr );
	bool malloc_zero_fill( void * addr );
	size_t malloc_size( void * addr );
	size_t malloc_usable_size( void * addr );
	int malloc_stats_fd( int fd );
	int malloc_info( int options, FILE * stream );
	int mallopt( int param_number, int value );
	size_t malloc_expansion() __attribute__((weak));	// heap expansion size (bytes)
	size_t malloc_mmap_start() __attribute__((weak));	// crossover allocation size from sbrk to mmap
	size_t malloc_unfreed() __attribute__((weak));		// heap unfreed size (bytes)
} // extern "C"

#ifdef __cforall
void * resize( void * oaddr, size_t alignment, size_t size );
void * realloc( void * oaddr, size_t alignment, size_t size );
#else
extern "C" {
	void * _X6resizeFPv_Pvmm__1( void * oaddr, size_t alignment, size_t size );
	void * _X7reallocFPv_Pvmm__1( void * oaddr, size_t alignment, size_t size );
}
#endif

// Local Variables: //
// tab-width: 4 //
// End: //
