//                               -*- Mode: Asm -*- 
//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CtxSwitch-x86_64.S --
//
// Author           : Thierry Delisle
// Created On       : Mon Nov 28 12:27:26 2016
// Last Modified By : Thierry Delisle
// Last Modified On : Mon Nov 28 12:27:26 2016
// Update Count     : 0
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

// This context switch routine depends on the fact that the stack of a new
// thread has been set up to look like the thread has saved its context in
// the normal manner.
//
// void CtxSwitch( machine_context *from, machine_context *to );

// Offsets in the context structure. This needs to be synchronized with the
// high level code a little better.

#define PTR_BYTE	8
#define SP_OFFSET	( 0 * PTR_BYTE )
#define FP_OFFSET	( 1 * PTR_BYTE )
#define PC_OFFSET	( 2 * PTR_BYTE )

.text
	.align 2
.globl	CtxSwitch
CtxSwitch:

	// Save volatile registers on the stack.

	subq   $8,%rsp
	stmxcsr 0(%rsp)         // 4 bytes
	fnstcw  4(%rsp)         // 2 bytes
	pushq %r15
	pushq %r14
	pushq %r13
	pushq %r12
	pushq %rbx

	// Save old context in the "from" area.

	movq %rsp,SP_OFFSET(%rdi)
	movq %rbp,FP_OFFSET(%rdi)

	// Load new context from the "to" area.

	movq SP_OFFSET(%rsi),%rsp
	movq FP_OFFSET(%rsi),%rbp

	// Load volatile registers from the stack.

	popq %rbx
	popq %r12
	popq %r13
	popq %r14
	popq %r15
	fldcw   4(%rsp)
	ldmxcsr 0(%rsp)
	addq $8,%rsp

	// Return to thread.

	ret

.text
	.align 2
.globl	CtxInvokeStub
CtxInvokeStub:
	movq %rbx, %rdi 
	jmp *%r12

.text
	.align 2
.globl	CtxGet
CtxGet:
	movq %rsp,SP_OFFSET(%rdi)
	movq %rbp,FP_OFFSET(%rdi)

	ret

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
