//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TupleExpr.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 10:59:19 2015
// Update Count     : 1
//

#include "Expression.h"
#include "Common/utility.h"
#include "Type.h"
#include "Declaration.h"

TupleExpr::TupleExpr( Expression *_aname ) : Expression( _aname ) {
}

TupleExpr::TupleExpr( const TupleExpr &other ) : Expression( other ) {
	cloneAll( other.exprs, exprs );
}

TupleExpr::~TupleExpr() {
	deleteAll( exprs );
}

void TupleExpr::print( std::ostream &os, int indent ) const {
	os << std::string( indent, ' ' ) << "Tuple:" << std::endl;
	printAll( exprs, os, indent+2 );
	Expression::print( os, indent );
}

TupleIndexExpr::TupleIndexExpr( Expression * tuple, unsigned int index ) {
	// TupleType * type = safe_dynamic_cast< TypeType * >( tuple->get_ )
	assert( tuple->get_results().size() >= index );
	add_result( *std::next( tuple->get_results().begin(), index ) );
}

TupleIndexExpr::TupleIndexExpr( const TupleIndexExpr &other ) : Expression( other ), tuple( other.tuple->clone() ), index( other.index ) {
}

TupleIndexExpr::~TupleIndexExpr() {
	delete tuple;
}

void TupleIndexExpr::print( std::ostream &os, int indent ) const {
	os << std::string( indent, ' ' ) << "Tuple Index Expression, with tuple:" << std::endl;
	tuple->print( os, indent+2 );
	os << std::string( indent+2, ' ' ) << "with index: " << index << std::endl;
	Expression::print( os, indent );
}

MemberTupleExpr::MemberTupleExpr( Expression * member, Expression * aggregate, Expression * _aname ) : Expression( _aname ) {
	cloneAll( member->get_results(), get_results() ); // xxx - ???
}

MemberTupleExpr::MemberTupleExpr( const MemberTupleExpr &other ) : Expression( other ), member( other.member->clone() ), aggregate( other.aggregate->clone() ) {
}

MemberTupleExpr::~MemberTupleExpr() {
	delete member;
	delete aggregate;
}

void MemberTupleExpr::print( std::ostream &os, int indent ) const {
	os << std::string( indent, ' ' ) << "Member Tuple Expression, with aggregate:" << std::endl;
	aggregate->print( os, indent+2 );
	os << std::string( indent+2, ' ' ) << "with member: " << std::endl;
	member->print( os, indent+2 );
	Expression::print( os, indent );
}


TupleAssignExpr::TupleAssignExpr( const std::list< Expression * > & assigns, const std::list< ObjectDecl * > & tempDecls, Expression * _aname ) : Expression( _aname ), assigns( assigns ), tempDecls( tempDecls ) {
	for ( Expression * expr : assigns ) {
		cloneAll( expr->get_results(), get_results() );
	}
}

TupleAssignExpr::TupleAssignExpr( const TupleAssignExpr &other ) : Expression( other ), tempDecls( other.tempDecls ) /* temporary */ {
	cloneAll( other.assigns, assigns );
	// xxx - clone needs to go into assigns and replace tempDecls
}

TupleAssignExpr::~TupleAssignExpr() {
	deleteAll( assigns );
	// deleteAll( tempDecls );
}

void TupleAssignExpr::print( std::ostream &os, int indent ) const {
	os << std::string( indent, ' ' ) << "Tuple Assignment Expression, with temporaries:" << std::endl;
	printAll( tempDecls, os, indent+4 );
	os << std::string( indent+2, ' ' ) << "with assignments: " << std::endl;
	printAll( assigns, os, indent+4 );
	Expression::print( os, indent );
}



// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
