//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// SemanticError.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Aug 29 18:17:35 2017
// Update Count     : 3
//

#include <cstdio>										// for fileno, stderr
#include <unistd.h>										// for isatty
#include <iostream>										// for basic_ostream, operator<<, ostream
#include <list>											// for list, _List_iterator
#include <string>										// for string, operator<<, operator+, to_string

#include "Common/utility.h"								// for to_string, CodeLocation (ptr only)
#include "SemanticError.h"

SemanticError::SemanticError() {
}

SemanticError::SemanticError( std::string error ) {
	append( error );
}

void SemanticError::append( SemanticError &other ) {
	errors.splice( errors.end(), other.errors );
}

void SemanticError::append( const std::string & msg ) {
	errors.emplace_back( error_str() + msg );
}

bool SemanticError::isEmpty() const {
	return errors.empty();
}

void SemanticError::print( std::ostream &os ) {
	using std::to_string;
	for( auto err : errors ) {
		os << to_string( err.location ) << err.description << std::endl;
	}
}

void SemanticError::set_location( const CodeLocation& location ) {
	errors.begin()->maybeSet( location );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
