//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LinkageSpec.cc --
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:22:09 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Oct  2 23:16:21 2016
// Update Count     : 23
//

#include <memory>
#include <string>
#include <cassert>
using namespace std;

#include "LinkageSpec.h"
#include "Common/SemanticError.h"

LinkageSpec::Spec LinkageSpec::linkageCheck( const string * spec ) {
	unique_ptr<const string> guard( spec );	// allocated by lexer
	if ( *spec == "\"Cforall\"" ) {
		return Cforall;
	} else if ( *spec == "\"C\"" ) {
		return C;
	} else {
		throw SemanticError( "Invalid linkage specifier " + *spec );
	} // if
}

string LinkageSpec::linkageName( LinkageSpec::Spec linkage ) {
	assert( 0 <= linkage && linkage < LinkageSpec::NoOfSpecs );
	static const char *linkageKinds[LinkageSpec::NoOfSpecs] = {
		"intrinsic", "Cforall", "C", "automatically generated", "compiler built-in",
	};
	return linkageKinds[linkage];
}

bool LinkageSpec::isDecoratable( Spec spec ) {
	assert( 0 <= spec && spec < LinkageSpec::NoOfSpecs );
	static bool decoratable[LinkageSpec::NoOfSpecs] = {
		//	Intrinsic,	Cforall,	C,		AutoGen,	Compiler
			true,		true,		false,	true,		false,
	};
	return decoratable[spec];
}

bool LinkageSpec::isGeneratable( Spec spec ) {
	assert( 0 <= spec && spec < LinkageSpec::NoOfSpecs );
	static bool generatable[LinkageSpec::NoOfSpecs] = {
		//	Intrinsic,	Cforall,	C,		AutoGen,	Compiler
			true,		true,		true,	true,		false,
	};
	return generatable[spec];
}

bool LinkageSpec::isOverridable( Spec spec ) {
	assert( spec >= 0 && spec < LinkageSpec::NoOfSpecs );
	static bool overridable[LinkageSpec::NoOfSpecs] = {
		//	Intrinsic,	Cforall,	C,		AutoGen,	Compiler
			true,		false,		false,	true,		false,
	};
	return overridable[spec];
}

bool LinkageSpec::isBuiltin( Spec spec ) {
	assert( spec >= 0 && spec < LinkageSpec::NoOfSpecs );
	static bool builtin[LinkageSpec::NoOfSpecs] = {
		//	Intrinsic,	Cforall,	C,		AutoGen,	Compiler
			true,		false,		false,	false,		true,
	};
	return builtin[spec];
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
