//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Declaration.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Feb  9 14:28:05 2017
// Update Count     : 16
//

#include <string>
#include <map>
#include "Declaration.h"
#include "Expression.h"
#include "Initializer.h"
#include "Type.h"
#include "Attribute.h"
#include "Common/utility.h"

static UniqueId lastUniqueId = 0;
typedef std::map< UniqueId, Declaration* > IdMapType;
static IdMapType idMap;

Declaration::Declaration( const std::string &name, DeclarationNode::StorageClass sc, LinkageSpec::Spec linkage )
		: name( name ), storageClass( sc ), linkage( linkage ), isInline( false ), isNoreturn( false ), uniqueId( 0 ) {
}

Declaration::Declaration( const Declaration &other )
	: name( other.name ), storageClass( other.storageClass ), linkage( other.linkage ), isInline( other.isInline ), isNoreturn( other.isNoreturn ), uniqueId( other.uniqueId ) {
}

Declaration::~Declaration() {
}

void Declaration::fixUniqueId() {
	uniqueId = ++lastUniqueId;
	idMap[ uniqueId ] = this;
}

Declaration *Declaration::declFromId( UniqueId id ) {
	IdMapType::const_iterator i = idMap.find( id );
	return i != idMap.end() ? i->second : 0;
}

void Declaration::dumpIds( std::ostream &os ) {
	for ( IdMapType::const_iterator i = idMap.begin(); i != idMap.end(); ++i ) {
		os << i->first << " -> ";
		i->second->printShort( os );
		os << std::endl;
	} // for
}

std::ostream & operator<<( std::ostream & out, const Declaration * decl ) {
	if ( decl ){
		decl->print( out );
	} else {
		out << "nullptr";
	}
	return out;
}


AsmDecl::AsmDecl( AsmStmt *stmt ) : Declaration( "", DeclarationNode::NoStorageClass, LinkageSpec::C ), stmt( stmt ) {
}

AsmDecl::AsmDecl( const AsmDecl &other ) : Declaration( other ), stmt( maybeClone( other.stmt ) ) {
}

AsmDecl::~AsmDecl() {
	delete stmt;
}

void AsmDecl::print( std::ostream &os, int indent ) const {
	stmt->print( os, indent );
}

void AsmDecl::printShort( std::ostream &os, int indent ) const {
	stmt->print( os, indent );
}


// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
