//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// clib/cfathread.h --
//
// Author           : Thierry Delisle
// Created On       : Tue Sep 22 15:31:20 2020
// Last Modified By :
// Last Modified On :
// Update Count     :
//

#include "stddef.h"
#include "invoke.h"

#if defined(__cforall) || defined(__cpluplus)
extern "C" {
#endif
	//--------------------
	// Basic types
	struct cfathread_CRunner_t;
	typedef struct cfathread_CRunner_t * cfathread_t;

	//--------------------
	// Basic thread support
	cfathread_t cfathread_create( void (*main)( cfathread_t ) );
	void cfathread_join( cfathread_t );

	void cfathread_park( void );
	void cfathread_unpark( cfathread_t );
	void cfathread_yield( void );

	//--------------------
	// Basic kernel features
	void cfathread_setproccnt( int );


#if defined(__cforall) || defined(__cpluplus)
}
#endif
