#include <cassert>
#include <iostream>

bool bts(volatile size_t & target, size_t bit ) {
	bool result = false;
	asm volatile(
		"LOCK btsq %[bit], %[target]\n\t"
		:"=c" (result)
		: [target] "m" (target), [bit] "r" (bit)
	);
 	return result;
}

bool btr(volatile size_t & target, size_t bit ) {
	bool result = false;
	asm volatile(
		"LOCK btrq %[bit], %[target]\n\t"
		:"=c" (result)
		: [target] "m" (target), [bit] "r" (bit)
	);
 	return result;
}

int main() {
	volatile size_t i = 0;
	std::cout << std::hex << i << std::endl;
	assert(bts(i, 31));
	std::cout << std::hex << i << std::endl;
	assert(btr(i, 31));
	std::cout << std::hex << i << std::endl;
	return 0;
}