#pragma once

#ifndef NDEBUG
#include <cassert>
#include <cstdlib>

#define sstr(s) #s
#define xstr(s) sstr(s)

extern const char * __my_progname;

#define assertf(cond, ...) ({             \
	if(!(cond)) {                       \
		fprintf(stderr, "%s: " __FILE__ ":" xstr(__LINE__) ": %s: Assertion '" xstr(cond) "' failed.\n", __my_progname, __PRETTY_FUNCTION__); \
		fprintf(stderr, __VA_ARGS__); \
		fprintf(stderr, "\n"); \
		std::abort();                 \
	}                                   \
})
#else
#define assertf(cond, ...)
#endif
