//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Declaration.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Andrew Beach
// Last Modified On : Wed Aug  9 14:38:00 2017
// Update Count     : 25
//

#include <map>                       // for _Rb_tree_const_iterator, map<>::...
#include <ostream>                   // for ostream, operator<<, basic_ostre...
#include <string>                    // for string
#include <utility>                   // for pair

#include "Common/utility.h"          // for maybeClone
#include "Declaration.h"
#include "SynTree/BaseSyntaxNode.h"  // for BaseSyntaxNode
#include "SynTree/Statement.h"       // for AsmStmt
#include "SynTree/SynTree.h"         // for UniqueId
#include "Type.h"                    // for Type, Type::StorageClasses

static UniqueId lastUniqueId = 0;
typedef std::map< UniqueId, Declaration* > IdMapType;
static IdMapType idMap;

Declaration::Declaration( const std::string &name, Type::StorageClasses scs, LinkageSpec::Spec linkage )
		: name( name ), linkage( linkage ), storageClasses( scs ), uniqueId( 0 ) {
}

Declaration::Declaration( const Declaration &other )
	: BaseSyntaxNode( other ), name( other.name ), linkage( other.linkage ), extension( other.extension ), storageClasses( other.storageClasses ), uniqueId( other.uniqueId ) {
}

Declaration::~Declaration() {
}

void Declaration::fixUniqueId() {
	uniqueId = ++lastUniqueId;
	idMap[ uniqueId ] = this;
}

Declaration *Declaration::declFromId( UniqueId id ) {
	IdMapType::const_iterator i = idMap.find( id );
	return i != idMap.end() ? i->second : 0;
}

void Declaration::dumpIds( std::ostream &os ) {
	for ( IdMapType::const_iterator i = idMap.begin(); i != idMap.end(); ++i ) {
		os << i->first << " -> ";
		i->second->printShort( os );
		os << std::endl;
	} // for
}


AsmDecl::AsmDecl( AsmStmt *stmt ) : Declaration( "", Type::StorageClasses(), LinkageSpec::C ), stmt( stmt ) {
}

AsmDecl::AsmDecl( const AsmDecl &other ) : Declaration( other ), stmt( maybeClone( other.stmt ) ) {
}

AsmDecl::~AsmDecl() {
	delete stmt;
}

void AsmDecl::print( std::ostream &os, int indent ) const {
	stmt->print( os, indent );
}

void AsmDecl::printShort( std::ostream &os, int indent ) const {
	stmt->print( os, indent );
}


// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
