//                              -*- Mode: CFA -*-
//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// threads.c --
//
// Author           : Thierry Delisle
// Created On       : Tue Jan 17 12:27:26 2016
// Last Modified By : Thierry Delisle
// Last Modified On : --
// Update Count     : 0
//

#include "threads"

#include "kernel"
#include "libhdr.h"

#define __CFA_INVOKE_PRIVATE__
#include "invoke.h"

extern "C" {
	#include <stddef.h>
}

extern processor * get_this_processor();

//-----------------------------------------------------------------------------
// Forward declarations
forall( dtype T | is_thread(T) )
void start( T* this );

forall( dtype T | is_thread(T) )
void stop( T* this );

//-----------------------------------------------------------------------------
// Thread ctors and dtors

void ?{}(thread* this) {
	(&this->c){};
	this->c.name = "Anonymous Coroutine";
	(&this->lock){};
	this->next = NULL;
}

void ^?{}(thread* this) {
	^(&this->c){};
}

forall( dtype T | sized(T) | is_thread(T) | { void ?{}(T*); } )
void ?{}( scoped(T)* this ) {
	(&this->handle){};
	start(&this->handle);
}

forall( dtype T, ttype P | sized(T) | is_thread(T) | { void ?{}(T*, P); } )
void ?{}( scoped(T)* this, P params ) {
	(&this->handle){ params };
	start(&this->handle);
}

forall( dtype T | sized(T) | is_thread(T) | { void ^?{}(T*); } )
void ^?{}( scoped(T)* this ) {
	stop(&this->handle);
	^(&this->handle){};
}

//-----------------------------------------------------------------------------
// Starting and stopping threads
extern "C" {
      forall(dtype T | is_thread(T))
      void CtxInvokeThread(T * this);
}

extern void thread_schedule( thread * );

forall( dtype T | is_thread(T) )
void start( T* this ) {
	coroutine* thrd_c = get_coroutine(this);
	thread*  thrd_h = get_thread   (this);
	thrd_c->last = this_coroutine();
	get_this_processor()->current_coroutine = thrd_c;

	LIB_DEBUG_PRINTF("Thread start : %p (t %p, c %p)\n", this, thrd_c, thrd_h);

	create_stack(&thrd_c->stack, thrd_c->stack.size);
	CtxStart(this, CtxInvokeThread);
	CtxSwitch( thrd_c->last->stack.context, thrd_c->stack.context );

	LIB_DEBUG_PRINTF("Thread started : %p (t %p, c %p)\n", this, thrd_c, thrd_h);

	thread_schedule(thrd_h);
}

forall( dtype T | is_thread(T) )
void stop( T* this ) {
	thread*  thrd = get_thread(this);
	if( thrd->c.notHalted ) {
		lock( &thrd->lock );
	}
}

void yield( void ) {
	thread_schedule( this_thread() );
	suspend();
}

void ThreadCtxSwitch(coroutine* src, coroutine* dst) {
	dst->last = src;

	// set state of current coroutine to inactive
	src->state = Inactive;

	// set new coroutine that task is executing
	get_this_processor()->current_coroutine = dst;	

	// context switch to specified coroutine
	CtxSwitch( src->stack.context, dst->stack.context );
	// when CtxSwitch returns we are back in the src coroutine

	// set state of new coroutine to active
	src->state = Active;
}

// C Helper to signal the termination of a thread
// Used in invoke.c
extern "C" {
	void __thread_signal_termination( thread * this ) {
		this->c.state = Halt;
		this->c.notHalted = false;
		unlock( &this->lock );
	}
}

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
