#!/usr/bin/python3

import argparse, json, random, sys

parser = argparse.ArgumentParser()
parser.add_argument('--infile', type=argparse.FileType('r'), default=sys.stdin)
parser.add_argument('--outfile', type=argparse.FileType('w'), default=sys.stdout)

args = parser.parse_args()

data = json.load(args.infile)



print(len(data['values']))
print(int(len(data['values']) / 1000))

sample = random.sample(data['values'], int(len(data['values']) / 1000))
print(len(sample))

# Sort by timestamp (the second element)
# take second element for sort
def takeSecond(elem):
    return elem[1]

sample.sort(key=takeSecond)

data['values'] = sample
json.dump(data, args.outfile)