#!/usr/bin/python3

import argparse, json, math, os, sys, re
from PIL import Image
import numpy as np

def dir_path(string):
    if os.path.isdir(string):
        return string
    else:
        raise NotADirectoryError(string)

parser = argparse.ArgumentParser()
parser.add_argument('--path', type=dir_path, default=".cfadata", help= 'paste path to biog.txt file')
parser.add_argument('--out', type=argparse.FileType('w'), default=sys.stdout)

try :
	args = parser.parse_args()
except NotADirectoryError:
	print("Must use option --path to existing directory or have .cfadata in current directory", file=sys.stderr)
	sys.exit(1)

root, _, filenames = next(os.walk(args.path))

merged = []
counters = {}

max_cpu = 0
min_cpu = 1000000
max_tsc = 0
min_tsc = 18446744073709551615

#open the files
for filename in filenames:
	try:
		m = re.search('[A-z]+0x([0-9a-f]+)\.data', filename)
		me = m.group(1)
		counters[me] = 0
		with open(os.path.join(root, filename), 'r') as file:
			for line in file:
				raw = [int(x.strip()) for x in line.split(',')]

				## from/to
				high = (raw[1] >> 32)
				low  = (raw[1] & 0xffffffff)
				data = [me, raw[0], high, low]
				max_cpu = max(max_cpu, high, low)
				min_cpu = min(min_cpu, high, low)

				## number
				# high = (raw[1] >> 8)
				# low  = (raw[1] & 0xff)
				# data = [me, raw[0], high, low]
				# max_cpu = max(max_cpu, low)
				# min_cpu = min(min_cpu, low)


				max_tsc = max(max_tsc, raw[0])
				min_tsc = min(min_tsc, raw[0])
				merged.append(data)

	except Exception as e:
		print(e)
		pass


print({"max-cpu": max_cpu, "min-cpu": min_cpu, "max-tsc": max_tsc, "min-tsc": min_tsc})

# Sort by timestamp (the second element)
# take second element for sort
def takeSecond(elem):
    return elem[1]

merged.sort(key=takeSecond)

json.dump({"values":merged, "max-cpu": max_cpu, "min-cpu": min_cpu, "max-tsc": max_tsc, "min-tsc": min_tsc}, args.out)

# vmin = merged[ 0][1]
# vmax = float(merged[-1][1] - vmin) / 2500000000.0
# # print(vmax)

# bins = []
# for _ in range(0, int(math.ceil(vmax * 10))):
# 	bins.append([0] * (32 * 32))

# # print(len(bins))
# bins = np.array(bins)

# rejected = 0
# highest  = 0

# for x in merged:
# 	b = int(float(x[1] - vmin) / 250000000.0)
# 	from_ = x[2]
# 	if from_ < 0 or from_ > 32:
# 		rejected += 1
# 		continue;
# 	to_   = x[3]
# 	if to_ < 0 or to_ > 32:
# 		rejected += 1
# 		continue;
# 	idx = (to_ * 32) + from_
# 	bins[b][idx] = bins[b][idx] + 1
# 	highest = max(highest, bins[b][idx])

# bins = np.array(map(lambda x: np.int8(x * 255.0 / float(highest)), bins))

# print([highest, rejected])
# print(bins.shape)

# im = Image.fromarray(bins)
# im.save('test.png')

# vmax = merged[-1][1]

# diff = float(vmax - vmin) / 2500000000.0
# print([vmin, vmax])
# print([vmax - vmin, diff])

# print(len(merged))

# for b in bins:
# 	print(b)

# single = []
# curr = 0

# # merge the data
# # for (me, time, value) in merged:
# for (me, value) in merged:
# 	# check now much this changes
# 	old = counters[me]
# 	change = value - old
# 	counters[me] = value

# 	# add change to the current
# 	curr = curr + change
# 	single.append( value )

# 	pass

# print(single)

# single = sorted(single)[:len(single)-100]
# ms = max(single)
# single = [float(x) / 2500.0 for x in single]

#print
# for t, v in single:
# 	print([t, v])
# print(len(single))
# print(max(single))
# print(min(single))

# bins = [0, 5.37751600e+04, 1.06903320e+05, 1.60031480e+05, 2.13159640e+05, 2.66287800e+05, 3.19415960e+05, 3.72544120e+05, 4.25672280e+05, 4.78800440e+05, 5.31928600e+05, 5.85056760e+05, 6.38184920e+05, 6.91313080e+05, 7.44441240e+05, 7.97569400e+05, 8.50697560e+05, 9.03825720e+05, 9.56953880e+05, 1.01008204e+06, 1.06321020e+06, 1.11633836e+06, 1.16946652e+06, 1.22259468e+06, 1.27572284e+06, 1.32885100e+06, 1.38197916e+06, 1.43510732e+06, 1.48823548e+06, 1.54136364e+06, 1.59449180e+06, 1.64761996e+06, 1.70074812e+06, 1.75387628e+06, 1.80700444e+06, 1.86013260e+06, 1.91326076e+06, 1.96638892e+06, 2.01951708e+06, 2.07264524e+06, 2.12577340e+06, 2.17890156e+06, 2.23202972e+06, 2.28515788e+06, 2.33828604e+06, 2.39141420e+06, 2.44454236e+06, 2.49767052e+06, 2.55079868e+06, 2.60392684e+06, 3.0e+06]
# # bins = [float(x) / 2500.0 for x in bins]
# # print([round(b, 2) for b in bins])

# import numpy
# # hist1, _ = numpy.histogram(single, density=True, bins=50)
# hist2, _ = numpy.histogram(single, density=True, bins=bins)
# # print(hist1)
# print([1000.0 * h for h in hist2])
# # for v in single:
# # 	print([v])
