from __future__ import print_function

import os
import sys

try :
	sys.path.append(os.getcwd())
	from config import *

	SRCDIR = os.path.abspath(SRCDIR)
	BUILDDIR = os.path.abspath(BUILDDIR)
except:
	print('ERROR: missing config.py, re-run configure script.', file=sys.stderr)
	sys.exit(1)

class Architecture:
	KnownArchitectures = {
		'x64'			: 'x64',
		'x86-64'		: 'x64',
		'x86'			: 'x86',
		'i386'		: 'x86',
		'i486'		: 'x86',
		'i686'		: 'x86',
		'Intel 80386'	: 'x86',
		'arm'			: 'arm',
		'ARM'			: 'arm',
	}

	def __init__(self, arch):
		if arch:
			self.cross_compile = True
			try:
				self.target = Architecture.makeCanonical( arch )
			except KeyError:
				print("Unkown architecture %s" % arch)
				sys.exit(1)
		else:
			self.cross_compile = False
			try:
				arch = machine_default()
				self.target = Architecture.makeCanonical( arch )
			except KeyError:
				print("Running on unkown architecture %s" % arch)
				sys.exit(1)

		self.string = self.target

	def update(self):
		if not self.cross_compile:
			self.target = machine_default()
			self.string = self.target
			print("updated to %s" % self.target)

	def match(self, arch):
		return True if not arch else self.target == arch

	@classmethod
	def makeCanonical(_, arch):
		return Architecture.KnownArchitectures[arch]


class Debug:
	def __init__(self, value):
		self.string = "debug" if value else "no debug"
		self.flags  = """DEBUG_FLAGS="%s" """ % ("-debug" if value else "-nodebug")

def init( options ):
	global arch
	global dry_run
	global generating
	global make
	global debug
	global debugFlag

	dry_run    = options.dry_run
	generating = options.regenerate_expected
	make       = 'make'
	debug	     = Debug(options.debug)
	arch       = Architecture(options.arch)


def updateMakeCmd(force, jobs):
	global make

	make = "make" if not force else ("make -j%i" % jobs)


def set_machine_default( func ):
	global machine_default

	machine_default = func