set terminal pdf color enhanced size 6.0in,3.0in font "Times,17"
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

INDIR="build"
OUTDIR="build"

set macros
set output OUTDIR."/plot-string-pbv.pdf"

set multiplot layout 1, 2 ;


#set pointsize 2.0
set grid
set key bottom right
#set key at screen 0.45, screen 0.8
set xtics (1,2,5,10,20,50,100,200,500)
set logscale x
set logscale y 2
set xlabel "String length passed, varying (mean)"
set ylabel "Time per pass (ns, mean), log_{2} scale"
set yrange [4:64]
set linetype 3 dashtype 2
set linetype 4 dashtype 2
plot INDIR."/plot-string-pbv-varcorp.dat" \
	   i 0 using 1:2 title columnheader(1) with points lt rgb "red"	 pt  3  ps 1, \
	'' i 1 using 1:2 title columnheader(1) with points lt rgb "blue" pt  6  ps 1

set xlabel "String length passed, fixed"
set ylabel
plot INDIR."/plot-string-pbv-fixcorp.dat"  \
	   i 0 using 1:2 title columnheader(1) with points lt rgb "red"  pt  3  ps 1, \
	'' i 1 using 1:2 title columnheader(1) with points lt rgb "blue" pt  6  ps 1

unset multiplot
