# Read thesis-append-pbv.csv
# Output for string-graph-peq-sharing.dat

# Project details
# Filter operation=peq
# Split "series" goups of sut; only those in the "pretty" list
# Assert one row per string-length
# output:
# string-len op-duration
# in chunks, each headed by pertty(sut)

import pandas as pd
import numpy as np
import os
import sys

sys.path.insert(0, os.path.dirname(__file__))
from common import *

# re: apparent cherrypicking
# The system's response to the liveness threshold is not smooth.
# The system only uses the threshold to decide whether it will double the text heap again or not.
# The system's speed for a given string size in a given amount of memory is not affected by the specific value of the liveness threshold.
# Goals with this selection are
#  - showing one speed result per <string size, memory usage amount>
#  - cropping diminishing or negative returns for large memory sizes
#    - diminishing is obvious, already shown past chosen sweet spot in this selection
#    - negative caused by overflowing llc, not relevant to sting impl
favSizes = {20:[-1.0, 0.05, 0.1, 0.2, 0.5, 0.9],
            50:[-1.0, 0.05, 0.1, 0.2, 0.5, 0.9],
            100:[-1.0, 0.1, 0.2, 0.5, 0.9],
            200:[-1.0, 0.1, 0.2, 0.5, 0.9],
            500:[-1.0, 0.2, 0.4, 0.9, 0.98]}

defaultExpansions = [-1, 0.2]

cfatimings = loadParseTimingData('result-allocate-speed-cfa.csv',
                xClasNames=['expansion'], xClasDtypes={'expansion':'Float64'},
                xFactNames=['topIters'], xFactDtypes={'topIters':np.int64})

cfasizings = loadParseSizingData('result-allocate-space-cfa.ssv', xClasNames=['expansion'], xClasDtypes={'expansion':'Float64'})

stltimings = loadParseTimingData('result-allocate-speed-stl.csv',
                xClasNames=['expansion'], xClasDtypes={'expansion':'Float64'},
                xFactNames=['topIters'], xFactDtypes={'topIters':np.int64})

stlsizings = loadParseSizingData('result-allocate-space-stl.ssv', xClasNames=['expansion'], xClasDtypes={'expansion':'Float64'})

timings = pd.concat([cfatimings, stltimings])
sizings = pd.concat([cfasizings, stlsizings])

combined = pd.merge(
    left=timings,
    right=sizings[['sut', 'corpus','expansion','hw_cur_req_mem(B)']],
    on=['sut', 'corpus','expansion']
)

combined = combined.pivot_table( values=['op-duration-ns','hw_cur_req_mem(B)'], index=['corpus-meanlen-tgt', 'sut-platform', 'expansion'], aggfunc=['mean', 'min', 'max'] )
combined = combined.reset_index()
combined.columns = combined.columns.to_flat_index()

# text = combined.to_csv(header=True, index=True, sep='\t')
# print(text)


combined['is-default'] = np.isin(combined[('expansion','')], defaultExpansions).astype(int)



# print ('!!')
# print(combined)


# Emit

# First, for the CFA curves
sut = "cfa"
sutGroup = combined.groupby(('sut-platform','')).get_group(sut)

groupedSize = sutGroup.groupby(('corpus-meanlen-tgt',''))

for sz, szgroup in groupedSize:

    if sz in favSizes.keys():
            szgroup_sorted = szgroup.sort_values(by=('expansion',''))

            print('"{sut}, len={len}"'.format(sut=sut, len=sz))
            # print(szgroup_sorted)  ##
            # print(szgroup_sorted['expansion'], 'isin', favSizes[sz]) ##
            favoured = szgroup_sorted.loc[szgroup_sorted[('expansion','')].isin(favSizes[sz])]
            # print('!') ##
            # print(favoured) ##
            text = favoured[[('expansion',''),
                             ('mean','op-duration-ns'),
                             ('min','op-duration-ns'),
                             ('max','op-duration-ns'),
                             ('mean', 'hw_cur_req_mem(B)'),
                             ('min', 'hw_cur_req_mem(B)'),
                             ('max', 'hw_cur_req_mem(B)'),
                             'is-default']].to_csv(header=False, index=False, sep='\t')
            print(text)
            print()

# Again, for the STL-comparisons, default expansion only

atDefaults = combined.groupby('is-default').get_group(1)

for sz, szgroup in atDefaults.groupby(('corpus-meanlen-tgt','')):

    if sz in favSizes.keys():
            print(sz)
            text = szgroup[[('expansion',''),
                            ('mean','op-duration-ns'),
                            ('min','op-duration-ns'),
                            ('max','op-duration-ns'),
                            ('mean', 'hw_cur_req_mem(B)'),
                            ('min', 'hw_cur_req_mem(B)'),
                            ('max', 'hw_cur_req_mem(B)'),
                            ('sut-platform','')]].to_csv(header=False, index=False, sep='\t')
            print(text)
            print()
