#!/usr/bin/env python3
import sys
import math

def main():
    if len(sys.argv) != 4:
        print("Usage: script.py <start> <end> <ptsPerDouble>", file=sys.stderr)
        sys.exit(1)

    try:
        start = int(sys.argv[1])
        end = int(sys.argv[2])
        ptsPerDouble = float(sys.argv[3])
    except ValueError:
        print("Error: start and end must be integers; ptsPerDouble must be a float.", file=sys.stderr)
        sys.exit(1)

    if start <= 0 or end <= start or ptsPerDouble <= 0:
        print("Error: Ensure start > 0, end > start, ptsPerDouble > 0", file=sys.stderr)
        sys.exit(1)

    values = []
    i = 0
    last_val = None

    while True:
        val = int(start * 2 ** (i / ptsPerDouble))
        if val >= end:
            break
        if val != last_val:
            values.append(str(val))
            last_val = val
        i += 1

    print(" ".join(values))

if __name__ == "__main__":
    main()
