set terminal pdf color enhanced size 6.0in,4.0in font "Times,17"
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

INDIR="build"
OUTDIR="build"
SRCDIR="plots"

SCALE=1024

# common to all
set macros
set output OUTDIR."/plot-string-allocn.pdf"
set multiplot layout 1, 2 ;
set grid


#
# CFA multisize
#

#set errorbars dashtype '.'

set logscale x 2
set xlabel "Heap Used (B)"
set logscale y 10
set key outside top center

set ylabel "Duration (ns)" offset 2,0
set yrange[40:150]
set ytics add (40, 50, 60, 70, 80, 90, 110, 120, 130, 140, 150)

set xrange[32:8192]
set xtics rotate by -90
set xtics ("" 32, "64 k" 64, "" 128, "256 k" 256, "" 512, "1 M" 1024, "" 2048, "4 M" 4096)

# First each curve, then each default-expansion point
plot INDIR."/plot-string-allocn.dat" \
	   i 0 using ($5/SCALE):2     notitle               with lines      lt rgb "blue"        dt '.'  lw 2, \
	'' i 1 using ($5/SCALE):2     notitle               with lines      lt rgb "red"         dt '.'  lw 2, \
	'' i 2 using ($5/SCALE):2     notitle               with lines      lt rgb "brown"       dt '.'  lw 2, \
	'' i 3 using ($5/SCALE):2     title "tuning contour" with lines     lt rgb "black"       dt '.'  lw 2, \
	'' i 4 using ($5/SCALE):2     notitle               with lines      lt rgb "magenta"     dt '.'  lw 2, \
	'' i 0 using ($5/SCALE):2:3:4 notitle               with yerrorbars lt rgb "blue"    pt  7  ps 0.25 lw 1, \
	'' i 1 using ($5/SCALE):2:3:4 notitle               with yerrorbars lt rgb "red"     pt  7  ps 0.25 lw 1, \
	'' i 2 using ($5/SCALE):2:3:4 notitle               with yerrorbars lt rgb "brown"   pt  7  ps 0.25 lw 1, \
	'' i 3 using ($5/SCALE):2:3:4 notitle               with yerrorbars lt rgb "black"   pt  7  ps 0.25 lw 1, \
	'' i 4 using ($5/SCALE):2:3:4 notitle               with yerrorbars lt rgb "magenta" pt  7  ps 0.25 lw 1, \
	'' i 0 using ( ($8 == 1) ? ($5/SCALE) : 1/0 ):2 notitle with points lt rgb "blue"    pt  66 ps 2, \
	'' i 1 using ( ($8 == 1) ? ($5/SCALE) : 1/0 ):2 notitle with points lt rgb "red"     pt  66 ps 2, \
	'' i 2 using ( ($8 == 1) ? ($5/SCALE) : 1/0 ):2 notitle with points lt rgb "brown"   pt  66 ps 2, \
	'' i 3 using ( ($8 == 1) ? ($5/SCALE) : 1/0 ):2 title "default tuning" \
	                                                        with points lt rgb "black"   pt  66 ps 2, \
	'' i 4 using ( ($8 == 1) ? ($5/SCALE) : 1/0 ):2 notitle with points lt rgb "magenta" pt  66 ps 2, \
	'' i 0 using ($5/SCALE):2:("{/Times=15 len-\n20")  every ::1::1 with labels left  offset  0.75,0.25 textcolor rgb "blue"    notitle, \
	'' i 1 using ($5/SCALE):2:("{/Times=15 len-\n50")  every ::5::5 with labels right offset -0.6 ,1.5  textcolor rgb "red"     notitle, \
	'' i 2 using ($5/SCALE):2:("{/Times=15 len-\n100") every ::4::4 with labels right offset -0.75,0.5  textcolor rgb "brown"   notitle, \
	'' i 3 using ($5/SCALE):2:("{/Times=15 len-\n200") every ::4::4 with labels right offset -0.75,1.25 textcolor rgb "black"   notitle, \
	'' i 4 using ($5/SCALE):2:("{/Times=15 len-\n500") every ::4::4 with labels right offset -0.75,0.25 textcolor rgb "magenta" notitle, \
	'' i 5 using                          ($5/SCALE)        :2     notitle               with lines       lt rgb "#BF007F7F"               lw 8, \
	'' i 6 using                          ($5/SCALE)        :2     notitle               with lines       lt rgb "#BF007F7F"               lw 8, \
	'' i 7 using                          ($5/SCALE)        :2     notitle               with lines       lt rgb "#BF007F7F"               lw 8, \
	'' i 8 using                          ($5/SCALE)        :2     title "tradeoff"      with lines       lt rgb "#BF007F7F"              lw 8, \
	'' i 9 using                          ($5/SCALE)        :2     notitle               with lines       lt rgb "#BF007F7F"               lw 8, \
	'' i 5 using ( (strcol(8) eq "stl") ? ($5/SCALE) : 1/0 ):2:3:4 notitle               with yerrorbars  lt rgb "#00007F7F"  pt 6     ps 0.5 lw 2 ,       \
	'' i 6 using ( (strcol(8) eq "stl") ? ($5/SCALE) : 1/0 ):2:3:4 notitle               with yerrorbars  lt rgb "#00007F7F"  pt 6     ps 0.5 lw 2 ,       \
	'' i 7 using ( (strcol(8) eq "stl") ? ($5/SCALE) : 1/0 ):2:3:4 notitle               with yerrorbars  lt rgb "#00007F7F"  pt 6     ps 0.5 lw 2 ,       \
	'' i 8 using ( (strcol(8) eq "stl") ? ($5/SCALE) : 1/0 ):2:3:4 notitle               with yerrorbars  lt rgb "#00007F7F"  pt 6     ps 0.5 lw 2 , \
	'' i 9 using ( (strcol(8) eq "stl") ? ($5/SCALE) : 1/0 ):2:3:4 notitle               with yerrorbars  lt rgb "#00007F7F"  pt 6     ps 0.5 lw 2


unset ylabel
unset xlabel

unset xtics
unset ytics
unset yrange
unset xrange

unset logscale
unset xlabel
unset mxtics

#
# Attribution
#

set key outside top center vertical maxrows 3

set logscale x 2
#set mxtics 3                      # 3 steps within each doubling (e.g. 3 steps of of 32 between 32 and 128 => tick on 32s in there)

set yrange[0:105]
set ytics auto

set xrange[2.0e4:3e7]
# set xtics rotate by -90
# set xtics ("" 32, "64 k" 64, "" 128, "256 k" 256, "" 512, "1 M" 1024, "" 2048, "4 M" 4096)

set style fill solid 1.0

BAR_RELWD = 0.5
BAR_XSHIFT = (1+BAR_RELWD)**(-0.55)
LEN_X_SEP = 1.7

# get segment draw order (front to back) from metadata file
meta = system('cat '.SRCDIR.'/string-allocn-attrib-meta.dat')
STATS_words = words(meta)
array STATS_word[STATS_words]
do for [i=1:STATS_words] {
    STATS_word[i] = word(meta, i)
}



plot \
	for [i=STATS_words:1:-1] \
	INDIR.'/plot-string-allocn-attrib.dat' \
		using (stringcolumn("category") eq STATS_word[i] ? (BAR_XSHIFT*$1**LEN_X_SEP*$3/SCALE) : 1/0): \
			  (stringcolumn("category") eq STATS_word[i] ? ($5 + $8) : 1/0): \
			  (stringcolumn("category") eq STATS_word[i] ? (BAR_RELWD*(BAR_XSHIFT*$1**LEN_X_SEP*$3/SCALE)) : 1/0) \
		with boxes ls i title STATS_word[i], \
	INDIR."/plot-string-allocn.dat" \
	   i 1 using (50 **LEN_X_SEP*$5/SCALE):2     notitle with lines      lt rgb "red"         dt '.'  lw 2, \
	'' i 3 using (200**LEN_X_SEP*$5/SCALE):2     notitle with lines      lt rgb "black"       dt '.'  lw 2, \
	'' i 1 using ( ($8 == 1) ? (50 **LEN_X_SEP*$5/SCALE) : 1/0 ):2 notitle with points lt rgb "red"     pt  66 ps 2, \
	'' i 3 using ( ($8 == 1) ? (200**LEN_X_SEP*$5/SCALE) : 1/0 ):2 notitle with points lt rgb "black"   pt  66 ps 2, \
	'' i 1 using ( ($8 == 1) ? (50 **LEN_X_SEP*$5/SCALE) : 1/0 ):2:3:4 notitle with yerrorbars lt rgb "red"     pt  7  ps 0.25 lw 1, \
	'' i 3 using ( ($8 == 1) ? (200**LEN_X_SEP*$5/SCALE) : 1/0 ):2:3:4 notitle with yerrorbars lt rgb "black"   pt  7  ps 0.25 lw 1, \
	'' i 1 using (50 **LEN_X_SEP*$5/SCALE):2:("{/Times=15 len-\n50")  every ::5::5 with labels right offset -0.6 ,1.5  textcolor rgb "red"     notitle, \
	'' i 3 using (200**LEN_X_SEP*$5/SCALE):2:("{/Times=15 len-\n200") every ::4::4 with labels right offset -0.75,1.25 textcolor rgb "black"   notitle, \
	'' i 6 using                          (50 **LEN_X_SEP*$5/SCALE)        :2     notitle      with lines   lt rgb "#BF007F7F"               lw 8, \
	'' i 8 using                          (200**LEN_X_SEP*$5/SCALE)        :2     notitle      with lines   lt rgb "#BF007F7F"              lw 8, \
	'' i 6 using ( (strcol(8) eq "stl") ? (50 **LEN_X_SEP*$5/SCALE) : 1/0 ):2:3:4     notitle      with yerrorbars  lt rgb "#00007F7F"  pt 6     ps 0.5 lw 2 ,       \
	'' i 8 using ( (strcol(8) eq "stl") ? (200**LEN_X_SEP*$5/SCALE) : 1/0 ):2:3:4     notitle      with yerrorbars  lt rgb "#00007F7F"  pt 6     ps 0.5 lw 2


#	   i 6 using                          ($5/SCALE)        :2:(BAR_RELWD*($5/SCALE))     notitle               with boxes  lt rgb "grey"    , \
#	'' i 8 using                          ($5/SCALE)        :2:(BAR_RELWD*($5/SCALE))     notitle               with boxes  lt rgb "grey"    , \
#	'' i 6 using                          ($5/SCALE)        :($2-40):(BAR_RELWD*($5/SCALE))     notitle               with boxes  lt rgb "blue", \
#	'' i 8 using                          ($5/SCALE)        :($2-40):(BAR_RELWD*($5/SCALE))     notitle               with boxes  lt rgb "blue", \
