//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypeData.h --
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 15:18:36 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Nov  1 20:56:46 2018
// Update Count     : 196
//

#pragma once

#include <iosfwd>                // for ostream
#include <list>                  // for list
#include <string>                // for string

#include "ParseNode.h"           // for DeclarationNode, DeclarationNode::Ag...
#include "Parser/LinkageSpec.h"  // for Spec
#include "SynTree/Type.h"        // for Type, ReferenceToType (ptr only)
#include "SynTree/SynTree.h"     // for Visitor Nodes

struct TypeData {
	enum Kind { Basic, Pointer, Reference, Array, Function, Aggregate, AggregateInst, Enum, EnumConstant, Symbolic,
				SymbolicInst, Tuple, Typeof, Basetypeof, Builtin, GlobalScope, Qualified, Unknown };

	struct Aggregate_t {
		DeclarationNode::Aggregate kind;
		const std::string * name;
		DeclarationNode * params;
		ExpressionNode * actuals;						// holds actual parameters later applied to AggInst
		DeclarationNode * fields;
		bool body;
		bool anon;

		bool tagged;
		const std::string * parent;
	};

	struct AggInst_t {
		TypeData * aggregate;
		ExpressionNode * params;
		bool hoistType;
	};

	struct Array_t {
		ExpressionNode * dimension;
		bool isVarLen;
		bool isStatic;
	};

	struct Enumeration_t {
		const std::string * name;
		DeclarationNode * constants;
		bool body;
		bool anon;
	};

	struct Function_t {
		mutable DeclarationNode * params;				// mutables modified in buildKRFunction
		mutable DeclarationNode * idList;				// old-style
		mutable DeclarationNode * oldDeclList;
		StatementNode * body;
		ExpressionNode * withExprs;						// expressions from function's with_clause
	};

	struct Symbolic_t {
		const std::string * name;
		bool isTypedef;									// false => TYPEGENname, true => TYPEDEFname
		DeclarationNode * params;
		ExpressionNode * actuals;
		DeclarationNode * assertions;
	};

	struct Qualified_t {								// qualified type S.T
		TypeData * parent;
		TypeData * child;
	};

	CodeLocation location;

	Kind kind;
	TypeData * base;
	DeclarationNode::BasicType basictype = DeclarationNode::NoBasicType;
	DeclarationNode::ComplexType complextype = DeclarationNode::NoComplexType;
	DeclarationNode::Signedness signedness = DeclarationNode::NoSignedness;
	DeclarationNode::Length length = DeclarationNode::NoLength;
	DeclarationNode::BuiltinType builtintype = DeclarationNode::NoBuiltinType;

	Type::Qualifiers qualifiers;
	DeclarationNode * forall;

	Aggregate_t aggregate;
	AggInst_t aggInst;
	Array_t array;
	Enumeration_t enumeration;
	Function_t function;
	Symbolic_t symbolic;
	Qualified_t qualified;
	DeclarationNode * tuple;
	ExpressionNode * typeexpr;

	TypeData( Kind k = Unknown );
	~TypeData();
	void print( std::ostream &, int indent = 0 ) const;
	TypeData * clone() const;

	const std::string * leafName() const;
};

Type * typebuild( const TypeData * );
TypeData * typeextractAggregate( const TypeData * td, bool toplevel = true );
Type::Qualifiers buildQualifiers( const TypeData * td );
Type * buildBasicType( const TypeData * );
PointerType * buildPointer( const TypeData * );
ArrayType * buildArray( const TypeData * );
ReferenceType * buildReference( const TypeData * );
AggregateDecl * buildAggregate( const TypeData *, std::list< Attribute * > );
ReferenceToType * buildComAggInst( const TypeData *, std::list< Attribute * > attributes, LinkageSpec::Spec linkage );
ReferenceToType * buildAggInst( const TypeData * );
TypeDecl * buildVariable( const TypeData * );
EnumDecl * buildEnum( const TypeData *, std::list< Attribute * >, LinkageSpec::Spec );
TypeInstType * buildSymbolicInst( const TypeData * );
TupleType * buildTuple( const TypeData * );
TypeofType * buildTypeof( const TypeData * );
Declaration * buildDecl( const TypeData *, const std::string &, Type::StorageClasses, Expression *, Type::FuncSpecifiers funcSpec, LinkageSpec::Spec, Expression * asmName,
						 Initializer * init = nullptr, std::list< class Attribute * > attributes = std::list< class Attribute * >() );
FunctionType * buildFunction( const TypeData * );
void buildKRFunction( const TypeData::Function_t & function );

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
