//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// maybe.c -- May contain a value.
//
// Author           : Andrew Beach
// Created On       : Wed May 24 15:40:00 2017
// Last Modified By : Andrew Beach
// Last Modified On : Thr May 25 15:24:00 2017
// Update Count     : 1
//

#include <containers/maybe>
#include <assert>


forall(otype T)
void ?{}(maybe(T) * this) {
	this->has_value = false;
}

forall(otype T)
void ?{}(maybe(T) * this, T value) {
	this->has_value = true;
	(&this->value){value};
}

forall(otype T)
void ?{}(maybe(T) * this, maybe(T) other) {
	this->has_value = other.has_value;
	if (other.has_value) {
		(&this->value){other.value};
	}
}

forall(otype T)
maybe(T) ?=?(maybe(T) * this, maybe(T) that) {
	if (this->has_value & that.has_value) {
		this->value = that.value;
	} else if (this->has_value) {
		^(&this->value){};
		this->has_value = false;
	} else if (that.has_value) {
		this->has_value = true;
		(&this->value){that.value};
	}
}

forall(otype T)
void ^?{}(maybe(T) * this) {
	if (this->has_value) {
		^(&this->value){};
	}
}

forall(otype T)
bool ?!=?(maybe(T) this, zero_t) {
	return this.has_value;
}

forall(otype T)
maybe(T) maybe_value(T value) {
	return (maybe(T)){value};
}

forall(otype T)
maybe(T) maybe_none() {
	return (maybe(T)){};
}

forall(otype T)
bool has_value(maybe(T) * this) {
	return this->has_value;
}

forall(otype T)
T get(maybe(T) * this) {
	assertf(this->has_value, "attempt to get from maybe without value");
	return this->value;
}

forall(otype T)
void set(maybe(T) * this, T value) {
	if (this->has_value) {
		this->value = value;
	} else {
		this->has_value = true;
		(&this->value){value};
	}
}

forall(otype T)
void set_none(maybe(T) * this) {
	if (this->has_value) {
		this->has_value = false;
		^(&this->value){};
	}
}
