#pragma once

#include <fstream>
#include <stddef.h>
#include <stdlib>

//==============================================================================
// type safe malloc / free

forall(otype T)
T* new()
{
	T* p = malloc();
	p{};
	return p;
}

forall(otype T)
void delete(T* p)
{
	^p{};
	free(p);
}

//==============================================================================
// ref counter content

struct content_t
{
	int value;
	size_t count;
};

void ?{}(content_t* this)
{
	sout | "Constructing content" | endl;
	this->count = 0;
}

void ^?{}(content_t* this)
{
	sout | "Destroying content" | endl;
}

//==============================================================================
// ref counter wrapper

struct wrapper_t
{
	content_t* ptr;
};

void ?{}(wrapper_t* this)
{
	sout | "Constructing empty ref pointer" | endl | endl;
	this->ptr = NULL;
}

void ?{}(wrapper_t* this, wrapper_t rhs)
{
	sout | "Constructing ref pointer from copy" | endl;
	this->ptr = rhs.ptr;
	this->ptr->count++;
	sout | "Reference is " | this->ptr->count | endl | endl;
}

void ^?{}(wrapper_t* this)
{
	if(this->ptr)
	{
		sout | "Destroying ref pointer" | endl;
		this->ptr->count--;
		sout | "Reference is " | this->ptr->count | endl | endl;
		if(!this->ptr->count) delete(this->ptr);
	}
	else
	{
		sout | "Destroying empty ref pointer" | endl | endl;
	}
}

wrapper_t ?=?(wrapper_t* this, wrapper_t rhs)
{
	sout | "Setting ref pointer" | endl;
	if(this->ptr)
	{
		this->ptr->count--;
		sout | "Reference is " | this->ptr->count | endl | endl;
		if(!this->ptr->count) delete(this->ptr);
	}
	this->ptr = rhs.ptr;
	this->ptr->count++;
	sout | "Reference is " | this->ptr->count | endl | endl;
}

void set(wrapper_t* this, content_t* c)
{
	this->ptr = c;
	this->ptr->count++;
	sout | "Setting ref pointer" | endl;
	sout | "Reference is " | this->ptr->count | endl | endl;
}

void clear(wrapper_t* this)
{
	sout | "Clearing ref pointer" | endl;
	this->ptr->count--;
	sout | "Reference is " | this->ptr->count | endl | endl;
	if(!this->ptr->count) delete(this->ptr);
	this->ptr = NULL;
}


wrapper_t wrap(int val)
{
	wrapper_t w;
	content_t* c = malloc();
	c{};
	c->value = val;
	set(&w, c);
	return w;
}
