//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Resolver.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 12:18:34 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Thu Apr 14 15:06:53 2016
// Update Count     : 2
//

#ifndef RESOLVER_H
#define RESOLVER_H

#include "SynTree/SynTree.h"
#include "SymTab/Indexer.h"

namespace ResolvExpr {
	/// Checks types and binds syntactic constructs to typed representations
	void resolve( std::list< Declaration * > translationUnit );
	Expression *resolveInVoidContext( Expression *expr, const SymTab::Indexer &indexer );
	Expression *findVoidExpression( Expression *untyped, const SymTab::Indexer &indexer );
} // namespace ResolvExpr

#endif // RESOLVER_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
