#include <fstream>
#include <kernel>
#include <monitor>
#include <thread>

monitor global_t {
	int value;
};

global_t global;

condition cond;

thread Signalee {};
thread Signaler {};

void step1( global_t * mutex this ) {
	sout | "Step 1" | endl;
	this->value = 1;
	wait( &cond );
}

void step2( global_t * mutex this ) {
	if( this->value != 1) abort();

	sout | "Step 2" | endl;
	this->value = 2;
	signal( &cond );
}

void step3( global_t * mutex this ) {
	if( this->value != 2) abort();

	sout | "Step 3" | endl;
	this->value = 3;
	signal( &cond );
}

void main( Signalee* this ) {
	step1( &global );
	step3( &global );
}

void main( Signaler* this ) {
	for(int i = 0; i < 10_000; i++) {
		asm volatile ("" : : : "memory");
	}

	step2( &global );
}

int main(int argc, char* argv[]) {
	assert( global.__mon.entry_queue.tail != NULL );
	processor p;
	{
		Signalee a;
		Signaler b;
	}
	if( global.value != 3) abort();
}