//
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// fibonacci.c --
//
// Author           : Thierry Delisle
// Created On       : Thu Jun  8 07:29:37 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Sep 17 21:38:15 2017
// Update Count     : 7
//

#include <fstream>
#include <coroutine>

coroutine Fibonacci {
	int fn;												// used for communication
};

void ?{}( Fibonacci & this ) {
	this.fn = 0;
}

void main( Fibonacci & this ) {
	int fn1, fn2;										// retained between resumes
	this.fn = 0;										// case 0
	fn1 = this.fn;
	suspend();											// restart last resume

	this.fn = 1;										// case 1
	fn2 = fn1;  fn1 = this.fn;
	suspend();											// restart last resume

	for ( ;; ) {										// general case
		this.fn = fn1 + fn2;
		fn2 = fn1;  fn1 = this.fn;
		suspend();										// restart last resume
	} // for
}

int next( Fibonacci & this ) {
	resume( this );										// restart last suspend
	return this.fn;
}

int main() {
	Fibonacci f1, f2;
	for ( int i = 1; i <= 10; i += 1 ) {
		sout | next( f1 ) | next( f2 ) | endl;
	} // for
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa fibonacci.c" //
// End: //
