#!groovy


// For skipping stages
import org.jenkinsci.plugins.pipeline.modeldefinition.Utils

// Global for the stage name
StageName = ''

// wrapper around stage declaretion to be more verbose
// and allow showing as skipped in the UI
def BuildStage(String name, boolean run, Closure block ) {
	StageName = name
	echo " -------- ${StageName} -------- "
	if(run) {
		stage(name, block)
	} else {
		stage(name) { Utils.markStageSkippedForConditional(STAGE_NAME) }
	}
}

//===========================================================================================================
// Common compilation routines
//===========================================================================================================
def clean() {
	BuildStage('Cleanup', true) {
		// clean the build by wipping the build directory
		dir(BuildDir) {
			deleteDir()
		}
	}
}

return this;