//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// assert.c --
//
// Author           : Thierry Delisle
// Created On       : Mon Nov 28 12:27:26 2016
// Last Modified By : Thierry Delisle
// Last Modified On : Mon Nov 28 12:27:26 2016
// Update Count     : 0
//

#include "assert"
#include "stdlib"										// abort

extern "C" {
	#include <stdarg.h>								// varargs
	#include <stdio.h>								// fprintf

	extern const char * __progname;						// global name of running executable (argv[0])

	#define CFA_ASSERT_FMT "*CFA assertion error* from program \"%s\" in \"%s\" at line %d in file \"%s\""

	// called by macro assert in assert.h
	void __assert_fail( const char *assertion, const char *file, unsigned int line, const char *function ) {
		fprintf( stderr, CFA_ASSERT_FMT ".\n", __progname, function, line, file );
		abort();
	}

	// called by macro assertf
	void __assert_fail_f( const char *assertion, const char *file, unsigned int line, const char *function, const char *fmt, ... ) {
		fprintf( stderr, CFA_ASSERT_FMT ": ", __progname, function, line, file );
		va_list args;
		va_start( args, fmt );
		vfprintf( stderr, fmt, args );
		abort();
	}

}

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
