//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// assert.h --
//
// Author           : Peter A. Buhr
// Created On       : Thu Aug 18 13:19:26 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 18 13:25:55 2016
// Update Count     : 4
//

#pragma once
// Pragmas for header cleanup tool
// IWYU pragma: private, include <cassert>

#include_next <assert.h>

#define __STRINGIFY__(str) #str
#define __VSTRINGIFY__(str) __STRINGIFY__(str)
#define assertf(expr, fmt, ...) ((expr) ? static_cast<void>(0) : __assert_fail_f(__VSTRINGIFY__(expr), __FILE__, __LINE__, __PRETTY_FUNCTION__, fmt, ## __VA_ARGS__ ))

void __assert_fail_f( const char *assertion, const char *file, unsigned int line, const char *function, const char *fmt, ... ) __attribute__((noreturn));

template<typename T, typename U>
static inline T safe_dynamic_cast(const U& src) {
	T ret = dynamic_cast<T>(src);
	assert(ret);
	return ret;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
