// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// rational.c -- test rational number package
// 
// Author           : Peter A. Buhr
// Created On       : Mon Mar 28 08:43:12 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Apr 27 17:05:19 2017
// Update Count     : 40
// 

#include <limits>
#include <rational>
#include <fstream>

int main() {
	sout | "constructor" | endl;
	Rational a = { 3 }, b = { 4 }, c;
	sout | a | b | c | endl;
	a = (Rational){ 4, 8 };
	b = (Rational){ 5, 7 };
	sout | a | b | endl;
	a = (Rational){ -2, -3 };
	b = (Rational){ 3, -2 };
	sout | a | b | endl;
	a = (Rational){ -2, 3 };
	b = (Rational){ 3, 2 };
	sout | a | b | endl;

	sout | "logical" | endl;
	a = (Rational){ -2 };
	b = (Rational){ -3, 2 };
	sout | a | b | endl;
//	sout | a == 1 | endl; // FIX ME
	sout | a != b | endl;
	sout | a <  b | endl;
	sout | a <= b | endl;
	sout | a >  b | endl;
	sout | a >= b | endl;

	sout | "arithmetic" | endl;
	sout | a | b | endl;
	sout | a + b | endl;
	sout | a - b | endl;
	sout | a * b | endl;
	sout | a / b | endl;

	sout | "conversion" | endl;
	a = (Rational){ 3, 4 };
	sout | widen( a ) | endl;
	a = (Rational){ 1, 7 };
	sout | widen( a ) | endl;
	a = (Rational){ 355, 113 };
	sout | widen( a ) | endl;
	sout | narrow( 0.75, 4 ) | endl;
	sout | narrow( 0.14285714285714, 16 ) | endl;
	sout | narrow( 3.14159265358979, 256 ) | endl;

	sout | "decompose" | endl;
	RationalImpl n, d;
	[n, d] = a;
	sout | a | n | d | endl;

	sout | "more tests" | endl;
	Rational x = { 1, 2 }, y = { 2 };
	sout | x - y | endl;
	sout | x > y | endl;
	sout | x | numerator( x, 2 ) | x | endl;
	sout | y | denominator( y, -2 ) | y | endl;

	Rational z = { 0, 5 };
	sout | z | endl;

	sout | x | numerator( x, 0 ) | x | endl;

	x = (Rational){ 1, MAX } + (Rational){ 1, MAX };
	sout | x | endl;
	x = (Rational){ 3, MAX } + (Rational){ 2, MAX };
	sout | x | endl;

	sin | &a | &b;
	sout | a | b | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa rational.c" //
// End: //
