//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FixFunction.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 16:19:49 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Mar  6 23:36:59 2017
// Update Count     : 6
//

#include "FixFunction.h"

#include <list>                   // for list

#include "Common/utility.h"       // for maybeClone
#include "SynTree/Declaration.h"  // for FunctionDecl, ObjectDecl, Declarati...
#include "SynTree/Expression.h"   // for Expression
#include "SynTree/Type.h"         // for ArrayType, PointerType, Type, Basic...

namespace SymTab {
	FixFunction::FixFunction() : isVoid( false ) {}

	DeclarationWithType * FixFunction::mutate(FunctionDecl *functionDecl) {
		// can't delete function type because it may contain assertions, so transfer ownership to new object
		ObjectDecl *pointer = new ObjectDecl( functionDecl->get_name(), functionDecl->get_storageClasses(), functionDecl->get_linkage(), 0, new PointerType( Type::Qualifiers(), functionDecl->get_type() ), 0, functionDecl->get_attributes() );
		functionDecl->get_attributes().clear();
		functionDecl->type = nullptr;
		delete functionDecl;
		return pointer;
	}

	Type * FixFunction::mutate(VoidType *voidType) {
		isVoid = true;
		return voidType;
	}

	Type * FixFunction::mutate(BasicType *basicType) {
		return basicType;
	}

	Type * FixFunction::mutate(PointerType *pointerType) {
		return pointerType;
	}

	Type * FixFunction::mutate(ArrayType *arrayType) {
		// need to recursively mutate the base type in order for multi-dimensional arrays to work.
		PointerType *pointerType = new PointerType( arrayType->get_qualifiers(), arrayType->get_base()->clone()->acceptMutator( *this ), maybeClone( arrayType->get_dimension() ), arrayType->get_isVarLen(), arrayType->get_isStatic() );
		delete arrayType;
		return pointerType;
	}

	Type * FixFunction::mutate(StructInstType *aggregateUseType) {
		return aggregateUseType;
	}

	Type * FixFunction::mutate(UnionInstType *aggregateUseType) {
		return aggregateUseType;
	}

	Type * FixFunction::mutate(EnumInstType *aggregateUseType) {
		return aggregateUseType;
	}

	Type * FixFunction::mutate(TraitInstType *aggregateUseType) {
		return aggregateUseType;
	}

	Type * FixFunction::mutate(TypeInstType *aggregateUseType) {
		return aggregateUseType;
	}

	Type * FixFunction::mutate(TupleType *tupleType) {
		return tupleType;
	}

	Type * FixFunction::mutate(VarArgsType *varArgsType) {
		return varArgsType;
	}

	Type * FixFunction::mutate(ZeroType *zeroType) {
		return zeroType;
	}

	Type * FixFunction::mutate(OneType *oneType) {
		return oneType;
	}
} // namespace SymTab

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
