//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FixInit.h --
//
// Author           : Rob Schluntz
// Created On       : Wed Jan 13 16:29:30 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Jan 19 13:25:13 2016
// Update Count     : 27
//

#include <stack>
#include <list>
#include "RemoveInit.h"
#include "SynTree/Declaration.h"
#include "SynTree/Type.h"
#include "SynTree/Expression.h"
#include "SynTree/Statement.h"
#include "SynTree/Initializer.h"
#include "SynTree/Mutator.h"
#include "GenPoly/PolyMutator.h"

namespace InitTweak {
	namespace {
		const std::list<Label> noLabels;
	}

	class FixInit : public GenPoly::PolyMutator {
	  public:
		static void fixInitializers( std::list< Declaration * > &translationUnit );

		virtual ObjectDecl * mutate( ObjectDecl *objDecl );

		virtual CompoundStmt * mutate( CompoundStmt * compoundStmt );
	};

	void fix( std::list< Declaration * > & translationUnit ) {
		FixInit::fixInitializers( translationUnit );
	}

	void FixInit::fixInitializers( std::list< Declaration * > & translationUnit ) {
		FixInit fixer;
		mutateAll( translationUnit, fixer );
	}

	// in the case where an object has an initializer and a polymorphic type, insert an assignment immediately after the
	// declaration. This will (seemingly) cause the later phases to do the right thing with the assignment
	ObjectDecl *FixInit::mutate( ObjectDecl *objDecl ) {
		if ( ConstructorInit * ctorInit = dynamic_cast< ConstructorInit * >( objDecl->get_init() ) ) {
			// a decision should have been made by the resolver, so ctor and init are not both non-NULL
			assert( ! ctorInit->get_ctor() || ! ctorInit->get_init() );
			if ( Expression * ctor = ctorInit->get_ctor() ) {
				ExprStmt * ctorStmt = new ExprStmt( noLabels, ctor );
				stmtsToAddAfter.push_back( ctorStmt );
				objDecl->set_init( NULL );
				ctorInit->set_ctor( NULL );
			} else if ( Initializer * init = ctorInit->get_init() ) {
				objDecl->set_init( init );
				ctorInit->set_init( NULL );
			} else {
				// no constructor and no initializer, which is okay
				objDecl->set_init( NULL );
			}
			delete ctorInit;
		}
		return objDecl;
	}

	CompoundStmt * FixInit::mutate( CompoundStmt * compoundStmt ) {
		std::list< Statement * > & statements = compoundStmt->get_kids();
		for ( std::list< Statement * >::iterator it = statements.begin(); it != statements.end(); ++it ) {
			// remove if instrinsic destructor statement
			// xxx - test user manually calling intrinsic functions - what happens?
			if ( ExprStmt * exprStmt = dynamic_cast< ExprStmt * >( *it ) ) {
				if ( ApplicationExpr * appExpr = dynamic_cast< ApplicationExpr * >( exprStmt->get_expr() ) ) {
					if ( VariableExpr * function = dynamic_cast< VariableExpr * >( appExpr->get_function() ) ) {
						if ( function->get_var()->get_name() == "^?{}" && function->get_var()->get_linkage() == LinkageSpec::Intrinsic ) {
							statements.erase(it++);
						}
					}
				}
			}
		}
		// mutate non-destructor statements
		return Mutator::mutate( compoundStmt );
	}

} // namespace InitTweak

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
