//                              -*- Mode: CFA -*-
//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// alarm.h --
//
// Author           : Thierry Delisle
// Created On       : Fri Jun 2 11:31:25 2017
// Last Modified By : Thierry Delisle
// Last Modified On : --
// Update Count     : 0
//

#ifndef ALARM_H
#define ALARM_H

#include <stdbool.h>

#include "assert"

typedef unsigned long int __cfa_time_t;

struct thread_desc;
struct processor;

//=============================================================================================
// Clock logic
//=============================================================================================

#define TIMEGRAN 1_000_000_000L				// nanosecond granularity, except for timeval

__cfa_time_t __kernel_get_time();
void __kernel_set_timer( __cfa_time_t alarm );

//=============================================================================================
// Alarm logic
//=============================================================================================

struct alarm_node_t {
	__cfa_time_t alarm;		// time when alarm goes off
	__cfa_time_t period;		// if > 0 => period of alarm
	alarm_node_t * next;		// intrusive link list field

	union {
		thread_desc * thrd;	// thrd who created event
		processor * proc;		// proc who created event
	};

	bool set		:1;		// whether or not the alarm has be registered
	bool kernel_alarm	:1;		// true if this is not a user defined alarm
};

typedef alarm_node_t ** __alarm_it_t;

void ?{}( alarm_node_t & this, thread_desc * thrd, __cfa_time_t alarm = 0, __cfa_time_t period = 0 );
void ?{}( alarm_node_t & this, processor   * proc, __cfa_time_t alarm = 0, __cfa_time_t period = 0 );
void ^?{}( alarm_node_t & this );

struct alarm_list_t {
	alarm_node_t * head;
	__alarm_it_t tail;
};

static inline void ?{}( alarm_list_t & this ) {
	this.head = 0;
	this.tail = &this.head;
}

void insert( alarm_list_t * this, alarm_node_t * n );
alarm_node_t * pop( alarm_list_t * this );

void register_self  ( alarm_node_t * this );
void unregister_self( alarm_node_t * this );

#endif

// Local Variables: //
// mode: CFA //
// tab-width: 6 //
// End: //
