//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LineStream.h -- Modified stream that inserts line directives into output.
//
// Author           : Andrew Beach
// Created On       : Wed May 4 09:15:00 2017
// Last Modified By : Andrew Beach
// Last Modified On : Fri May 5 14:29:00 2017
// Update Count     : 1
//

#ifndef LINE_STREAM_H
#define LINE_STREAM_H

#include <ostream>
#include <sstream>
#include <string>

#include "Common/utility.h"

namespace CodeGen {

	class LineStream : public std::ostream {
		std::ostream & baseStream;
		std::ostringstream buffer;

		bool const insertLines;

		CodeLocation actualLocation;
		CodeLocation expectedLocation;

		void printLineDirective(CodeLocation const & location);
		bool actualDiffersFromExpected() const;
		void emptyBuffer(bool addNewline);

	public:
		typedef std::ostream &(*StreamFlag)(std::ostream &);

		LineStream(std::ostream & baseStream, bool insertLines) :
			baseStream(baseStream), insertLines(insertLines)
		{}

		/// Update the currentLocation in source code.
		void setLoc(CodeLocation const & location);

		/// Formated output is buffered until flushed.
		std::ostream & operator<<(char const *str);
		std::ostream & operator<<(std::string str);
		std::ostream & operator<<(StreamFlag flag);

	}; // LineStream

} // CodeGen

#endif // LINE_STREAM_H
