// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// math1.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Apr 22 14:59:21 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu May 24 21:01:15 2018
// Update Count     : 85
// 

#include <fstream>
#include <math>

int main( void ) {
	float f;
	double d;
	long double l;

	sout | "fmod:" | 5.0F % -2.0F | fmod( 5.0F, -2.0F ) | 5.0D % -2.0D | fmod( 5.0D, -2.0D ) | 5.0L % -2.0L | fmod( 5.0L, -2.0L ) | endl;
	sout | "remainder:" | remainder( 2.0F, 3.0F ) | remainder( 2.0D, 3.0D ) | remainder( 2.0L, 3.0L ) | endl;
	int quot;
	f = remquo( 3.6F, 0.5F, &quot );
	sout | "remquo:" | quot | f;
	d = remquo( 3.6D, 0.5F, &quot );
	sout | quot | d;
	l = remquo( 3.6L, 0.5L, &quot );
	sout | quot | l | endl;
	sout | "div:" | div( 3.6F, 0.5F ) | div( 3.6D, 0.5D ) | div( 3.6L, 0.5L ) | endl;
	sout | "fma:" | fma( 3.0F, -1.0F, 1.0F ) | fma( 3.0D, -1.0D, 1.0D ) | fma( 3.0L, -1.0L, , 1.0L ) | endl;
	sout | "fdim:" | fdim( 1.0F, -1.0F ) | fdim( 1.0D, -1.0D ) | fdim( 1.0L, -1.0L ) | endl;
	sout | "nan:" | (float)nan( "" ) | (double)nan( "" ) | (long double)nan( "" ) | endl;

	//---------------------- Exponential ----------------------

	sout | "exp:" | exp( 1.0F ) | exp( 1.0D ) | exp( 1.0L ) | exp( 1.0F+1.0FI ) | exp( 1.0D+1.0DI ) | exp( 1.0DL+1.0LI ) | endl;
	sout | "exp2:" | exp2( 1.0F ) | exp2( 1.0D ) | exp2( 1.0L ) | endl;
	sout | "expm1:" | expm1( 1.0F ) | expm1( 1.0D ) | expm1( 1.0L ) | endl;
	sout | "pow:" | pow( 1.0F, 1.0F ) | pow( 1.0D, 1.0D ) | pow( 1.0L, 1.0L ) | pow( 1.0F+1.0FI, 1.0F+1.0FI ) | pow( 1.0D+1.0DI, 1.0D+1.0DI ) | pow( 1.0DL+1.0LI, 1.0DL+1.0LI ) | endl;

	int b = 4;
	unsigned int e = 2;
    b \= e;
    sout | "\\" | b | b \ e | endl;
    sout | "\\" | 'a' \ 3u | 2 \ 8u | 4 \ 3u | -4 \ 3u | 4 \ -3 | -4 \ -3 | 4.0 \ 2.1 | (1.0f+2.0fi) \ (3.0f+2.0fi) | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa math1.c" //
// End: //
