// Conditional Match (or Re-Raise)
#include <chrono>
#include <cstdlib>
#include <exception>
#include <iostream>

using namespace std::chrono;

struct EmptyException : public std::exception {};

bool should_catch = false;

void throw_exception() {
	throw EmptyException();
}

void cond_catch() {
	try {
		throw_exception();
	} catch (EmptyException & exc) {
		if (should_catch) {
			throw;
		}
	}
}

int main(int argc, char * argv[]) {
	unsigned int times = 1;
	unsigned int total_frames = 1;
	if (1 < argc) {
		times = strtol(argv[1], nullptr, 10);
	}
	if (2 < argc) {
		total_frames = strtol(argv[2], nullptr, 10);
	}

	time_point<steady_clock> start_time = steady_clock::now();
    for (unsigned int count = 0 ; count < times ; ++count) {
        try {
			cond_catch();
		} catch (EmptyException &) {
			// ...
		}
    }
	time_point<steady_clock> end_time = steady_clock::now();
	nanoseconds duration = duration_cast<nanoseconds>(end_time - start_time);
	std::cout << "Run-Time (ns): " << duration.count() << std::endl;
}
