#include <kernel>
#include <math>
#include <thread>
#include <time>

#include "long_tests.h"

#ifndef PREEMPTION_RATE
#error PREEMPTION_RATE not defined in makefile
#endif

Duration default_preemption() {
	return PREEMPTION_RATE;
}

thread worker_t {};

void main(worker_t & this) {
	volatile long long p = 5_021_609ul;
	volatile long long a = 326_417ul;
	volatile long long n = 1l;
	for (volatile long long i = 0; TEST(i < p); i++) {
		n *= a;
		n %= p;
		KICK_WATCHDOG;
	}

	if( !TEST(n == a) ) {
		abort();
	}
}

extern "C" {
static worker_t * workers;
}

int main(int argc, char* argv[]) {
	processor p;
	{
		worker_t w[7];
		workers = w;
	}
}
