#!/bin/bash

set -e

GIT_UPDATE="$1/GIT_UPDATE"
GIT_LOG="$1/GIT_LOG"
GIT_DIFF="$1/GIT_DIFF"

rm -f ${GIT_UPDATE}  ${GIT_LOG}  ${GIT_DIFF}

GitOldRef=$2
GitNewRef=$3


revisions=$(git rev-list ${GitOldRef}..${GitNewRef})

for rev in ${revisions}; do
    type=$(git cat-file -t ${rev})
    echo "       via  ${rev} (${type})" >>  ${GIT_UPDATE}
done
rev=${GitOldRef}
type=$(git cat-file -t ${rev})
echo "      from  ${rev} (${type})" >>  ${GIT_UPDATE}

git rev-list --format=short ${GitOldRef}...${GitNewRef} >  ${GIT_LOG}

git diff --stat ${GitNewRef} ${GitOldRef} >  ${GIT_DIFF}