import matplotlib.pyplot as plt
import numpy as np

import sys

if __name__ == "__main__":
	if len(sys.argv) > 2:
		print('USAGE: %s [FILE]' % sys.argv[0], file=sys.stderr)
		sys.exit(1)

	with plt.xkcd():
		fig = plt.figure()
		ax = fig.add_axes((0.1, 0.2, 0.8, 0.7))
		ax.spines['right'].set_color('none')
		ax.spines['top'].set_color('none')
		ax.set_xticks([])
		ax.set_yticks([])
		ax.set_ylim([-30, 10])

		x = np.linspace(1, 100, 100)

		fair = ((x / 15) ** 2)  - 28
		ax.annotate('Fairness', xy=(70, 1), xytext=(80, 1))
		ax.plot(fair)

		local = (((x - 100) / 17.5) ** 2)  - 28
		ax.annotate('Locality', xy=(70, 1), xytext=(1, 1))
		ax.plot(local, color='r')

		ax.set_xlabel('Ready Time')
		ax.set_ylabel('Importance')
		if len(sys.argv) == 1:
			plt.show()
		else :
			plt.rcParams["savefig.format"] = "svg"
			plt.rcParams["savefig.bbox"] = "tight"
			plt.rcParams["svg.fonttype"] = 'none'
			plt.savefig(sys.argv[1], format="svg")
