//
// Cforall Version 1.0.0 Copyright (C) 2018 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Heap.cc --
//
// Author           : Peter A. Buhr
// Created On       :
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu May  3 16:16:10 2018
// Update Count     : 2
//

#include <cassert>
#include <cmath>
#include <cstddef>
#include <cstring>
#include <iomanip>
#include <iostream>

namespace HeapStats {
	#if !defined( WITH_HEAP_STATISTICS )
		void newPass( const char * const ) {}

		void printStats() {}
	#else
		struct StatBlock {
			const char * name = nullptr;
			size_t mallocs    = 0;
			size_t frees      = 0;
		};

		StatBlock    passes[100];
		const size_t passes_size = sizeof(passes) / sizeof(passes[0]);
		size_t       passes_cnt = 0;

		void newPass( const char * const name ) {
			passes[passes_cnt].name    = name;
			passes[passes_cnt].mallocs = 0;
			passes[passes_cnt].frees   = 0;
			passes_cnt++;

			assertf(passes_cnt < passes_size, "Too many passes for HeapStats, increase the size of the array in Heap.h");
		}

		void printStats() {
			size_t nc = 0;
			for(size_t i = 0; i < passes_cnt; i++) {
				nc = std::max(nc, std::strlen(passes[i].name));
			}

			const char * const title = "Heap Usage Statistic";
			for(size_t i = 0; i < (nc + 30); i++) std::cerr << '='; std::cerr << '\n';
			for(size_t i = 0; i < (nc + 30 - std::strlen(title)) / 2; i++) std::cerr << ' ';
			std::cerr << title << std::endl;
			for(size_t i = 0; i < (nc + 30); i++) std::cerr << '-'; std::cerr << '\n';
			std::cerr << std::setw(nc) << "Pass";
			std::cerr << " | Malloc Count |   Free Count" << std::endl;
			for(size_t i = 0; i < (nc + 30); i++) std::cerr << '-'; std::cerr << '\n';
			for(size_t i = 0; i < passes_cnt; i++) {
				std::cerr << std::setw(nc) << passes[i].name    << " | ";
				std::cerr << std::setw(12) << passes[i].mallocs << " | ";
				std::cerr << std::setw(12) << passes[i].frees   << "\n";
			}
		}
	#endif
}

