#include "server.hpp"
#include "log.hpp"

namespace server {
      class server {
      public:
            void check_ready() {
                  if(!ready) {
                        throw json::obj({
                              { "code", -32002 },
                              { "message", "Server not initialized" }
                        });
                  }
            }

            void init() { ready = true; };
      private:
            bool ready = false;

      };

      static server g_server;

      json::obj init( const json::obj & ) {
            g_server.init();
		return {
			{ "capabilities", {
                        {"textDocumentSync", {
                              {"openClose", true},
                              {"change", 1}
                        }},
                        {"documentHighlightProvider", {
                              {"workDoneProgress", false}
                        }},
                        {"completionProvider", {
                              {"triggerCharacters", json::obj::array()},
                              {"allCommitCharacters", json::obj::array()},
                              {"resolveProvider", true}
                        }}
                  } },
			{ "serverInfo", {
				{ "name", "Cforall Language Server" },
				{ "version", "0.1" }
			}}
		};
	}
}