#include <assert.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdlib.h>

#define DESTROY(x)

//------------------------------------------------------------------------------
//Declaration
context allocator_c(type T, type allocator_t) {
	void reallocate(allocator_t*, size_t);
	T* data(allocator_t*);
};

forall(type T, type allocator_t | allocator_c(T, allocator_t))
struct vector
{
	allocator_t storage;
	size_t size;
};

//------------------------------------------------------------------------------
//Capacity
forall(type T, type allocator_t | allocator_c(T, allocator_t))
bool empty(vector(T, allocator_t)* this)
{
	return this->size == 0;
}

forall(type T, type allocator_t | allocator_c(T, allocator_t))
bool size(vector(T, allocator_t)* this)
{
	return this->size;
}

forall(type T, type allocator_t | allocator_c(T, allocator_t))
void reserve(vector(T, allocator_t)* this, size_t size)
{
	reallocate(&this->storage, this->size+1);
}

//------------------------------------------------------------------------------
//Element access
forall(type T, type allocator_t | allocator_c(T, allocator_t))
T at(vector(T, allocator_t)* this, size_t index)
{
	//assert(index < this->size);
	return data(&this->storage)[index];
}

forall(type T, type allocator_t | allocator_c(T, allocator_t))
T ?[?](vector(T, allocator_t)* this, size_t index)
{
	return data(&this->storage)[index];
}

forall(type T, type allocator_t | allocator_c(T, allocator_t))
T front(vector(T, allocator_t)* this)
{
	return data(&this->storage)[0];
}

forall(type T, type allocator_t | allocator_c(T, allocator_t))
T back(vector(T, allocator_t)* this, size_t index)
{
	return data(&this->storage)[this->size - 1];
}

//------------------------------------------------------------------------------
//Modifiers
forall(type T, type allocator_t | allocator_c(T, allocator_t))
void push_back(vector(T, allocator_t)* this, T value)
{
	reallocate(&this->storage, this->size+1);
	data(&this->storage)[this->size] = value;
	this->size++;
}

forall(type T, type allocator_t | allocator_c(T, allocator_t))
void pop_back(vector(T, allocator_t)* this)
{
	this->size--;
	DESTROY(data(&this->storage)[this->size]);
}

forall(type T, type allocator_t | allocator_c(T, allocator_t))
void clear(vector(T, allocator_t)* this)
{
	for(size_t i = 0; i < this->size; i++)
	{
		DESTROY(data(&this->storage)[this->size]);
	}
	this->size = 0;
}

//------------------------------------------------------------------------------
//Allocator
forall(type T)
struct heap_allocator
{
	T* storage;
	size_t capacity;
};

forall(type T)
void reallocate(heap_allocator(T)* this, size_t size)
{
	static const size_t GROWTH_RATE = 2;
	if(size > this->capacity)
	{
		this->capacity = GROWTH_RATE * size;
		this->storage = (T*)realloc((void*)this->storage, this->capacity * sizeof(T));
	}
}

forall(type T)
T* data(heap_allocator(T)* this)
{
	return this->storage;
}
