#include <stdbool.h>
#include <stdint.h>

#ifdef __CFORALL__
extern "C" {
#endif

#if ! defined(__CFA_INVOKE_PRIVATE__)
#ifndef _INVOKE_H_
#define _INVOKE_H_

      #define unlikely(x)    __builtin_expect(!!(x), 0)

      struct coStack_t {
            unsigned int size;		// size of stack
            void *storage;			// pointer to stack
            void *limit;			// stack grows towards stack limit
            void *base;				// base of stack
            void *context;			// address of cfa_context_t
            void *top;				// address of top of storage
            bool userStack;	
      };

      enum coroutine_state { Start, Inactive, Active, Halt, Primed };

      struct coroutine {
            struct coStack_t stack;
            const char *name;			// textual name for coroutine/task, initialized by uC++ generated code
            int errno_;				// copy of global UNIX variable errno
            enum coroutine_state state;	// current execution status for coroutine
            bool notHalted;			// indicate if execuation state is not halted

            struct coroutine *starter;	// first coroutine to resume this one
            struct coroutine *last;		// last coroutine to resume this one
      };

      struct thread_h {
            struct coroutine c;
      };

#endif //_INVOKE_H_
#else //! defined(__CFA_INVOKE_PRIVATE__)
#ifndef _INVOKE_PRIVATE_H_
#define _INVOKE_PRIVATE_H_
      
      struct machine_context_t {
            void *SP;
            void *FP;
            void *PC;
      };

      // assembler routines that performs the context switch
      extern void CtxInvokeStub( void );
      void CtxSwitch( void * from, void * to ) asm ("CtxSwitch");
      void CtxGet( void * this ) asm ("CtxGet");

#endif //_INVOKE_PRIVATE_H_
#endif //! defined(__CFA_INVOKE_PRIVATE__)
#ifdef __CFORALL__
}
#endif
