//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// vector_test.c --
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Apr 06 17:19:07 2016
// Update Count     : 18
//

#include <fstream>
#include <iterator>
#include "vector_int.h"
#include "array.h"

int main( void ) {
	vector_int vec;

	// read in numbers until EOF or error
	int num;

	sout | "enter N elements and C-d on a separate line:" | endl;
	for ( ;; ) {
		sin | &num;
	  if ( fail( sin ) || eof( sin ) ) break;
		append( &vec, num );
	}
	// write out the numbers

	sout | "Array elements:" | endl;
	write( begin( vec ), end( vec ), sout );
	sout | endl;

	sout | "Array elements reversed:" | endl;
	write_reverse( begin( vec ), end( vec ), sout );
	sout | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa vector_test.c vector_int.o array.o" //
// End: //
