// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// pair.c --
//
// Author           : Aaron Moss
// Created On       : Wed Apr 12 15:32:00 2017
// Last Modified By : Aaron Moss
// Last Modified On : Wed Apr 12 15:32:00 2017
// Update Count     : 1
//

#include <containers/pair>

forall(otype R, otype S 
	| { int ?==?(R, R); int ?<?(R, R); int ?<?(S, S); })
int ?<?(pair(R, S) p, pair(R, S) q) {
	return p.first < q.first || ( p.first == q.first && p.second < q.second );
}

forall(otype R, otype S 
	| { int ?==?(R, R); int ?<?(R, R); int ?<=?(S, S); })
int ?<=?(pair(R, S) p, pair(R, S) q) {
	return p.first < q.first || ( p.first == q.first && p.second <= q.second );
}

forall(otype R, otype S | { int ?==?(R, R); int ?==?(S, S); })
int ?==?(pair(R, S) p, pair(R, S) q) {
	return p.first == q.first && p.second == q.second;
}

forall(otype R, otype S | { int ?!=?(R, R); int ?!=?(S, S); })
int ?!=?(pair(R, S) p, pair(R, S) q) {
	return p.first != q.first || p.second != q.second;
}

forall(otype R, otype S 
	| { int ?==?(R, R); int ?>?(R, R); int ?>?(S, S); })
int ?>?(pair(R, S) p, pair(R, S) q) {
	return p.first > q.first || ( p.first == q.first && p.second > q.second );
}

forall(otype R, otype S 
	| { int ?==?(R, R); int ?>?(R, R); int ?>=?(S, S); })
int ?>=?(pair(R, S) p, pair(R, S) q) {
	return p.first > q.first || ( p.first == q.first && p.second >= q.second );
}
