//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypeDecl.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Andrew Beach
// Last Modified On : Wed Aug  9 14:35:00 2017
// Update Count     : 6
//

#include <ostream>           // for ostream, operator<<, basic_ostream, basi...
#include <string>            // for string, char_traits, operator+, operator<<

#include "Common/utility.h"  // for maybeClone
#include "Declaration.h"     // for TypeDecl, TypeDecl::Data, TypeDecl::Kind...
#include "Type.h"            // for Type, Type::StorageClasses

TypeDecl::TypeDecl( const std::string &name, Type::StorageClasses scs, Type *type, Kind kind, Type * init ) : Parent( name, scs, type ), init( init ), sized( kind == Any || kind == Ttype ), kind( kind ) {
}

TypeDecl::TypeDecl( const TypeDecl &other ) : Parent( other ), init( maybeClone( other.init ) ), sized( other.sized ), kind( other.kind ) {
}

TypeDecl::~TypeDecl() {
  delete init;
}

std::string TypeDecl::typeString() const {
	static const std::string kindNames[] = { "type", "incomplete type", "function type", "tuple type" };
	return (kind != Any && isComplete() ? "sized " : "") + kindNames[ kind ];
}

std::string TypeDecl::genTypeString() const {
	static const std::string kindNames[] = { "otype", "dtype", "ftype", "ttype" };
	return kindNames[ kind ];
}

void TypeDecl::print( std::ostream &os, int indent ) const {
  NamedTypeDecl::print( os, indent );
  if ( init ) {
    os << std::endl << std::string( indent, ' ' ) << "with type initializer: ";
    init->print( os, indent + 2 );
  }
}


std::ostream & operator<<( std::ostream & os, const TypeDecl::Data & data ) {
  return os << data.kind << ", " << data.isComplete;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
