// Throw Across Finally

class EmptyException extends Exception {}

public class ThrowFinally {
	private static void unwind_finally(int frames)
			throws EmptyException {
		if (0 < frames) {
			unwind_finally(frames - 1);
		} else {
			throw new EmptyException();
		}
	}

	public static void main(String[] args) {
		int times = 1;
		int total_frames = 1;
		if (0 < args.length) {
			times = Integer.parseInt(args[0]);
		}
		if (1 < args.length) {
			total_frames = Integer.parseInt(args[1]);
		}

		for (int count = 0 ; count < times ; ++count) {
			try {
				unwind_finally(total_frames);
			} catch (EmptyException e) {
				// ...
			}
		}
	}
}
