// Throw Across Other Handler
#include <exception>
#include <cstdlib>

struct EmptyException : public std::exception {};

struct NotRaisedException {};

void unwind_other(unsigned int frames) {
	if (frames) {
		try {
			unwind_other(frames - 1);
		} catch (NotRaisedException &) {
			// ...
		}
	} else {
		throw (EmptyException){};
	}
}

int main(int argc, char * argv[]) {
	unsigned int times = 1;
	unsigned int total_frames = 1;
	if (2 < argc) {
		times = strtol(argv[1], nullptr, 10);
	}
	if (3 < argc) {
		total_frames = strtol(argv[2], nullptr, 10);
	}

	for (int count = 0 ; count < times ; ++count) {
		try {
			unwind_other(total_frames);
		} catch (EmptyException &) {
			// ...
		}
	}
}
