// Throw Across Destructor
#include <exception>
#include <cstdlib>

struct EmptyException : public std::exception {};

struct WithDestructor {
	~WithDestructor() {}
};

void unwind_destructor(unsigned int frames) {
	if (frames) {
		WithDestructor object;
		unwind_destructor(frames - 1);
	} else {
		throw (EmptyException){};
	}
}

int main(int argc, char * argv[]) {
	unsigned int times = 1;
	unsigned int total_frames = 1;
	if (2 < argc) {
		times = strtol(argv[1], nullptr, 10);
	}
	if (3 < argc) {
		total_frames = strtol(argv[2], nullptr, 10);
	}

	for (int count = 0 ; count < times ; ++count) {
		try {
			unwind_destructor(total_frames);
		} catch (EmptyException &) {
			// ...
		}
	}
}
