// Conditional Match (or Re-Raise)
#include <exception>
#include <cstdlib>

struct EmptyException : public std::exception {};

bool should_catch = false;

void throw_exception() {
	throw EmptyException();
}

void cond_catch() {
	try {
		throw_exception();
	} catch (EmptyException & exc) {
		if (should_catch) {
			throw;
		}
	}
}

int main(int argc, char * argv[]) {
	unsigned int times = 1;
	unsigned int total_frames = 1;
	if (2 < argc) {
		times = strtol(argv[1], nullptr, 10);
	}
	if (3 < argc) {
		total_frames = strtol(argv[2], nullptr, 10);
	}

    for (unsigned int count = 0 ; count < times ; ++count) {
        try {
			cond_catch();
		} catch (EmptyException &) {
			// ...
		}
    }
}
